/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.ConnectionNegotiationProperties;
import apicore.util.Logger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class OptionsManager {
    Properties props;
    Properties defaultProps;
    String propFile;
    private static String defaultPropFile = "pt_cep.properties";
    private static Map<String, Integer> connectOptions = new HashMap<String, Integer>();
    private static OptionsManager instance;

    private OptionsManager() {
        this(defaultPropFile);
    }

    private OptionsManager(String string) {
        this.propFile = string;
        this.setDefaultProps();
        this.props = new Properties(this.defaultProps);
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.propFile);
            if (inputStream == null) {
                inputStream = new FileInputStream(this.propFile);
            }
            this.props.load(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.error("Error loading properties from file " + this.propFile);
            Logger.error(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            Logger.error("Error loading properties from file " + this.propFile);
            Logger.error(iOException.getMessage());
        }
    }

    public static OptionsManager getInstance() {
        if (instance == null) {
            instance = new OptionsManager();
        }
        return instance;
    }

    public static OptionsManager getInstance(String string) {
        if (instance == null) {
            instance = new OptionsManager(string);
        }
        return instance;
    }

    private void setDefaultProps() {
        this.defaultProps = new Properties();
        this.defaultProps.setProperty("pt.cep.ptmp.uid", "{c6fbf435-3234-48bb-af04-debc4e4cf9f3}");
        this.defaultProps.setProperty("pt.cep.ptmp.signature", "PTMP");
        this.defaultProps.setProperty("pt.cep.ptmp.version", "1");
        this.defaultProps.setProperty("pt.cep.encoding", "TEXT_ENCODING");
        this.defaultProps.setProperty("pt.cep.encryption", "NO_ENCRYPTION");
        this.defaultProps.setProperty("pt.cep.compression", "NOT_COMPRESSED");
        this.defaultProps.setProperty("pt.cep.authentication", "MD5_AUTH");
        this.defaultProps.setProperty("pt.cep.auth.secret", "genericexapp123");
        this.defaultProps.setProperty("pt.cep.auth.application", "net.netacad.cisco.genericexapp");
        this.defaultProps.setProperty("pt.cep.keepAlivePeriod", "0");
    }

    public String getStringOpt(String string) {
        return this.props.getProperty(string);
    }

    public int getIntOpt(String string) {
        int n = 0;
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.error(numberFormatException.getMessage());
            }
        }
        return n;
    }

    public ConnectionNegotiationProperties getConnectOpts() {
        ConnectionNegotiationProperties connectionNegotiationProperties = new ConnectionNegotiationProperties();
        connectionNegotiationProperties.setSignature(this.props.getProperty("pt.cep.ptmp.signature"));
        connectionNegotiationProperties.setVersion(this.getIntOpt("pt.cep.ptmp.version"));
        connectionNegotiationProperties.setClientUid(this.props.getProperty("pt.cep.ptmp.uid"));
        connectionNegotiationProperties.setEncoding(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.encoding")));
        connectionNegotiationProperties.setEncryption(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.encryption")));
        connectionNegotiationProperties.setCompression(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.compression")));
        connectionNegotiationProperties.setAuthentication(this.getIntFromPmtpOpt(this.props.getProperty("pt.cep.authentication")));
        connectionNegotiationProperties.setClientTimestamp(ConnectionNegotiationProperties.yyyyMMddhhmmssDateFormatter.format(new Date()));
        connectionNegotiationProperties.setKeepAlivePeriod(this.getIntOpt("pt.cep.keepAlivePeriod"));
        connectionNegotiationProperties.setAuthenticationApplication(this.props.getProperty("pt.cep.auth.application"));
        connectionNegotiationProperties.setAuthenticationSecret(this.props.getProperty("pt.cep.auth.secret"));
        return connectionNegotiationProperties;
    }

    private int getIntFromPmtpOpt(String string) {
        Integer n = connectOptions.get(string);
        return n != null ? n : 0;
    }

    static {
        connectOptions.put("TEXT_ENCODING", 1);
        connectOptions.put("BINARY_ENCODING", 2);
        connectOptions.put("NO_ENCRYPTION", 1);
        connectOptions.put("XOR_ENCRYPTION", 2);
        connectOptions.put("NOT_COMPRESSED", 1);
        connectOptions.put("ZLIB_COMPRESSED", 2);
        connectOptions.put("CLEAR_TEXT_AUTH", 1);
        connectOptions.put("SIMPLE_AUTH", 2);
        connectOptions.put("MD5_AUTH", 4);
    }
}

